# Player Config ID: huggingface_DeepSeek-V3-0324_PayoffMaximizer_B (as Player B)
# Meta-Round: 6
# Experiment: PMxPM, Run: 3
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek-V3-0324_PayoffMaximizer_B_MR6_strategy.txt
# LLM Suggested Fallback: D

def velvet_glove(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    if not opp_history:  # Round 1
        return "C"
    
    current_round = len(my_history) + 1
    has_opp_defected = "D" in opp_history
    
    if current_round <= 3:
        if has_opp_defected:
            return "D"
        return "C"
    
    if current_round <= 8:
        if has_opp_defected:
            return "D"
        else:
            if random.random() < 0.2:  # 20% chance to defect
                return "D"
            return "C"
    
    # Rounds 9-10
    if has_opp_defected:
        return "D"
    else:
        if current_round == 9:
            return "D"
        return "C"